<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 ">Generate New Receipt</h1>
                </div>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <div class="mb-3 row">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('admin.receipts.index')); ?>" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i>Back to Receipts
                        </a>
                    </div>
                </div>

                <div class="mb-5 row">
                    <div class="col card p-3 shadow ">
                        <form action="<?php echo e(route('admin.receipts.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <!-- User Information -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-user me-2"></i>User Information</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="user_name" class="form-label">Full Name *</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['user_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="user_name" name="user_name" value="<?php echo e(old('user_name')); ?>" required>
                                                <?php $__errorArgs = ['user_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="mb-3">
                                                <label for="user_email" class="form-label">Email Address *</label>
                                                <input type="email" class="form-control <?php $__errorArgs = ['user_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="user_email" name="user_email" value="<?php echo e(old('user_email')); ?>" required>
                                                <?php $__errorArgs = ['user_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="mb-3">
                                                <label for="wallet_address" class="form-label">Wallet Address *</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['wallet_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="wallet_address" name="wallet_address" value="<?php echo e(old('wallet_address')); ?>" required>
                                                <?php $__errorArgs = ['wallet_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Transaction Information -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Transaction Information</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="amount" class="form-label">Amount *</label>
                                                <input type="number" step="0.00000001" class="form-control <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="amount" name="amount" value="<?php echo e(old('amount')); ?>" required>
                                                <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="mb-3">
                                                <label for="cryptocurrency" class="form-label">Cryptocurrency *</label>
                                                <select class="form-control <?php $__errorArgs = ['cryptocurrency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="cryptocurrency" name="cryptocurrency" required>
                                                    <option value="">Select Cryptocurrency</option>
                                                    <option value="BTC" <?php echo e(old('cryptocurrency') == 'BTC' ? 'selected' : ''); ?>>Bitcoin (BTC)</option>
                                                    <option value="ETH" <?php echo e(old('cryptocurrency') == 'ETH' ? 'selected' : ''); ?>>Ethereum (ETH)</option>
                                                    <option value="USDT" <?php echo e(old('cryptocurrency') == 'USDT' ? 'selected' : ''); ?>>Tether (USDT)</option>
                                                    <option value="USDC" <?php echo e(old('cryptocurrency') == 'USDC' ? 'selected' : ''); ?>>USD Coin (USDC)</option>
                                                    <option value="BNB" <?php echo e(old('cryptocurrency') == 'BNB' ? 'selected' : ''); ?>>Binance Coin (BNB)</option>
                                                    <option value="ADA" <?php echo e(old('cryptocurrency') == 'ADA' ? 'selected' : ''); ?>>Cardano (ADA)</option>
                                                    <option value="SOL" <?php echo e(old('cryptocurrency') == 'SOL' ? 'selected' : ''); ?>>Solana (SOL)</option>
                                                    <option value="DOT" <?php echo e(old('cryptocurrency') == 'DOT' ? 'selected' : ''); ?>>Polkadot (DOT)</option>
                                                    <option value="DOGE" <?php echo e(old('cryptocurrency') == 'DOGE' ? 'selected' : ''); ?>>Dogecoin (DOGE)</option>
                                                    <option value="LTC" <?php echo e(old('cryptocurrency') == 'LTC' ? 'selected' : ''); ?>>Litecoin (LTC)</option>
                                                </select>
                                                <?php $__errorArgs = ['cryptocurrency'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="mb-3">
                                                <label for="transaction_type" class="form-label">Transaction Type *</label>
                                                <select class="form-control <?php $__errorArgs = ['transaction_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="transaction_type" name="transaction_type" required>
                                                    <option value="">Select Transaction Type</option>
                                                    <option value="deposit" <?php echo e(old('transaction_type') == 'deposit' ? 'selected' : ''); ?>>Deposit</option>
                                                    <option value="withdrawal" <?php echo e(old('transaction_type') == 'withdrawal' ? 'selected' : ''); ?>>Withdrawal</option>
                                                    <option value="trade" <?php echo e(old('transaction_type') == 'trade' ? 'selected' : ''); ?>>Trade</option>
                                                    <option value="transfer" <?php echo e(old('transaction_type') == 'transfer' ? 'selected' : ''); ?>>Transfer</option>
                                                    <option value="spot_trading" <?php echo e(old('transaction_type') == 'spot_trading' ? 'selected' : ''); ?>>Spot Trading</option>
                                                    <option value="futures_trading" <?php echo e(old('transaction_type') == 'futures_trading' ? 'selected' : ''); ?>>Futures Trading</option>
                                                </select>
                                                <?php $__errorArgs = ['transaction_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Date and Additional Information -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-calendar me-2"></i>Date & Additional Information</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="transaction_date" class="form-label">Transaction Date *</label>
                                                <input type="datetime-local" class="form-control <?php $__errorArgs = ['transaction_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="transaction_date" name="transaction_date"
                                                       value="<?php echo e(old('transaction_date', date('Y-m-d\TH:i'))); ?>" required>
                                                <?php $__errorArgs = ['transaction_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="mb-3">
                                                <label for="transaction_fee" class="form-label">Transaction Fee</label>
                                                <input type="number" step="0.00000001" class="form-control <?php $__errorArgs = ['transaction_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="transaction_fee" name="transaction_fee" value="<?php echo e(old('transaction_fee', '0')); ?>">
                                                <?php $__errorArgs = ['transaction_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="mb-3">
                                                <label for="transaction_id" class="form-label">Transaction ID/Hash</label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['transaction_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       id="transaction_id" name="transaction_id" value="<?php echo e(old('transaction_id')); ?>"
                                                       placeholder="Optional">
                                                <?php $__errorArgs = ['transaction_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Template Selection -->
                                <div class="col-md-6">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <h5 class="mb-0"><i class="fas fa-palette me-2"></i>Receipt Template</h5>
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <label for="template_type" class="form-label">Select Template Style *</label>
                                                <select class="form-control <?php $__errorArgs = ['template_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        id="template_type" name="template_type" required>
                                                    <option value="">Choose Template</option>
                                                    <option value="bybit" <?php echo e(old('template_type') == 'bybit' ? 'selected' : ''); ?>>
                                                        Bybit Style (Dark Orange Theme)
                                                    </option>
                                                    <option value="binance" <?php echo e(old('template_type') == 'binance' ? 'selected' : ''); ?>>
                                                        Binance Style (Yellow Gold Theme)
                                                    </option>
                                                    <option value="coinbase" <?php echo e(old('template_type') == 'coinbase' ? 'selected' : ''); ?>>
                                                        Coinbase Style (Blue Professional Theme)
                                                    </option>
                                                </select>
                                                <?php $__errorArgs = ['template_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <!-- Template Preview -->
                                            <div id="templatePreview" class="mt-3" style="display: none;">
                                                <div class="alert alert-info">
                                                    <strong>Template Preview:</strong>
                                                    <span id="previewText"></span>
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label for="notes" class="form-label">Additional Notes</label>
                                                <textarea class="form-control <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                          id="notes" name="notes" rows="3"
                                                          placeholder="Any additional information for the receipt"><?php echo e(old('notes')); ?></textarea>
                                                <?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Action Buttons -->
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between">
                                                <a href="<?php echo e(route('admin.receipts.index')); ?>" class="btn btn-secondary">
                                                    <i class="fas fa-times me-1"></i>Cancel
                                                </a>
                                                <div>
                                                    <button type="submit" class="btn btn-primary">
                                                        <i class="fas fa-plus me-1"></i>Generate Receipt
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('template_type').addEventListener('change', function() {
            const previewDiv = document.getElementById('templatePreview');
            const previewText = document.getElementById('previewText');
            const value = this.value;
            
            if (value) {
                previewDiv.style.display = 'block';
                switch(value) {
                    case 'bybit':
                        previewText.textContent = 'Professional dark theme with orange accents, similar to Bybit exchange';
                        break;
                    case 'binance':
                        previewText.textContent = 'Clean yellow and gold theme, similar to Binance exchange';
                        break;
                    case 'coinbase':
                        previewText.textContent = 'Modern blue professional theme, similar to Coinbase exchange';
                        break;
                }
            } else {
                previewDiv.style.display = 'none';
            }
        });

        // Auto-generate transaction hash
        document.addEventListener('DOMContentLoaded', function() {
            const transactionIdField = document.getElementById('transaction_id');
            if (!transactionIdField.value) {
                transactionIdField.value = generateTransactionHash();
            }
        });

        function generateTransactionHash() {
            const chars = '0123456789abcdef';
            let result = '0x';
            for (let i = 0; i < 64; i++) {
                result += chars[Math.floor(Math.random() * chars.length)];
            }
            return result;
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\algodebug\resources\views/admin/receipts/create.blade.php ENDPATH**/ ?>