<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 ">Receipt Generator</h1>
                </div>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>
                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.success-alert','data' => []]); ?>
<?php $component->withName('success-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <!-- Stats Cards -->
                <div class="mb-4 row">
                    <div class="col-md-3">
                        <div class="card bg-primary text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Total Receipts</h6>
                                        <h3 class="mb-0"><?php echo e(\App\Models\Receipt::count()); ?></h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-receipt fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-success text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Today's Receipts</h6>
                                        <h3 class="mb-0"><?php echo e(\App\Models\Receipt::whereDate('created_at', today())->count()); ?></h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-calendar-day fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-info text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Bybit Style</h6>
                                        <h3 class="mb-0"><?php echo e(\App\Models\Receipt::where('template_type', 'bybit')->count()); ?></h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-chart-line fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="card bg-warning text-white">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <h6 class="card-title">Binance Style</h6>
                                        <h3 class="mb-0"><?php echo e(\App\Models\Receipt::where('template_type', 'binance')->count()); ?></h3>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-coins fa-2x"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Generate New Receipt Button -->
                <div class="mb-3 row">
                    <div class="col-md-12">
                        <a href="<?php echo e(route('admin.receipts.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>Generate New Receipt
                        </a>
                    </div>
                </div>

                <!-- Filters -->
                <div class="mb-3 row">
                    <div class="col card p-3 shadow">
                        <form method="GET" class="row g-3">
                            <div class="col-md-2">
                                <select name="template_type" class="form-control">
                                    <option value="">All Templates</option>
                                    <option value="bybit" <?php echo e(request('template_type') == 'bybit' ? 'selected' : ''); ?>>Bybit</option>
                                    <option value="binance" <?php echo e(request('template_type') == 'binance' ? 'selected' : ''); ?>>Binance</option>
                                    <option value="coinbase" <?php echo e(request('template_type') == 'coinbase' ? 'selected' : ''); ?>>Coinbase</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <select name="transaction_type" class="form-control">
                                    <option value="">All Types</option>
                                    <option value="deposit" <?php echo e(request('transaction_type') == 'deposit' ? 'selected' : ''); ?>>Deposit</option>
                                    <option value="withdrawal" <?php echo e(request('transaction_type') == 'withdrawal' ? 'selected' : ''); ?>>Withdrawal</option>
                                    <option value="trade" <?php echo e(request('transaction_type') == 'trade' ? 'selected' : ''); ?>>Trade</option>
                                    <option value="transfer" <?php echo e(request('transaction_type') == 'transfer' ? 'selected' : ''); ?>>Transfer</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_from" class="form-control" value="<?php echo e(request('date_from')); ?>" placeholder="From Date">
                            </div>
                            <div class="col-md-2">
                                <input type="date" name="date_to" class="form-control" value="<?php echo e(request('date_to')); ?>" placeholder="To Date">
                            </div>
                            <div class="col-md-2">
                                <input type="text" name="search" class="form-control" value="<?php echo e(request('search')); ?>" placeholder="Search...">
                            </div>
                            <div class="col-md-2">
                                <button type="submit" class="btn btn-secondary">
                                    <i class="fas fa-search me-1"></i>Filter
                                </button>
                                <a href="<?php echo e(route('admin.receipts.index')); ?>" class="btn btn-outline-secondary">
                                    <i class="fas fa-times"></i>
                                </a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="mb-5 row">
                    <div class="col card p-3 shadow ">
                        <div class="bs-example widget-shadow table-responsive" data-example-id="hoverable-table">
                            <span style="margin:3px;">
                                <table id="ShipTable" class="table table-hover ">
                                    <thead>
                                        <tr>
                                            <th>Receipt #</th>
                                            <th>User Name</th>
                                            <th>User Email</th>
                                            <th>Amount</th>
                                            <th>Transaction Type</th>
                                            <th>Template</th>
                                            <th>Status</th>
                                            <th>Date Created</th>
                                            <th>Option</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $receipts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $receipt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><strong><?php echo e($receipt->receipt_number); ?></strong></td>
                                            <td><?php echo e($receipt->user_name); ?></td>
                                            <td><?php echo e($receipt->user_email); ?></td>
                                            <td><?php echo e($receipt->formatted_amount); ?></td>
                                            <td>
                                                <?php switch($receipt->transaction_type):
                                                    case ('deposit'): ?>
                                                        <span class="badge badge-success"><?php echo e(ucfirst($receipt->transaction_type)); ?></span>
                                                        <?php break; ?>
                                                    <?php case ('withdrawal'): ?>
                                                        <span class="badge badge-warning"><?php echo e(ucfirst($receipt->transaction_type)); ?></span>
                                                        <?php break; ?>
                                                    <?php case ('trade'): ?>
                                                        <span class="badge badge-info"><?php echo e(ucfirst($receipt->transaction_type)); ?></span>
                                                        <?php break; ?>
                                                    <?php default: ?>
                                                        <span class="badge badge-secondary"><?php echo e(ucfirst($receipt->transaction_type)); ?></span>
                                                <?php endswitch; ?>
                                            </td>
                                            <td>
                                                <?php switch($receipt->template_type):
                                                    case ('bybit'): ?>
                                                        <span class="badge badge-dark">Bybit</span>
                                                        <?php break; ?>
                                                    <?php case ('binance'): ?>
                                                        <span class="badge badge-warning">Binance</span>
                                                        <?php break; ?>
                                                    <?php case ('coinbase'): ?>
                                                        <span class="badge badge-primary">Coinbase</span>
                                                        <?php break; ?>
                                                <?php endswitch; ?>
                                            </td>
                                            <td>
                                                <span class="badge badge-success"><?php echo e(ucfirst($receipt->status)); ?></span>
                                            </td>
                                            <td><?php echo e(\Carbon\Carbon::parse($receipt->created_at)->toDayDateTimeString()); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('admin.receipts.show', $receipt->id)); ?>" class="m-1 btn btn-info btn-sm">
                                                    <i class="fa fa-eye"></i> View
                                                </a>
                                                <a href="<?php echo e(route('admin.receipts.pdf', $receipt->id)); ?>" class="m-1 btn btn-success btn-sm">
                                                    <i class="fa fa-download"></i> PDF
                                                </a>
                                                <button class="m-1 btn btn-danger btn-sm" onclick="deleteReceipt(<?php echo e($receipt->id); ?>)">
                                                    <i class="fa fa-trash"></i> Delete
                                                </button>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="9" class="text-center py-4">
                                                <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                                <p class="text-muted">No receipts found</p>
                                                <a href="<?php echo e(route('admin.receipts.create')); ?>" class="btn btn-primary">
                                                    Generate Your First Receipt
                                                </a>
                                            </td>
                                        </tr>
                                        <?php endif; ?>
                                    </tbody>
                                </table>
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Pagination -->
                <?php if($receipts->hasPages()): ?>
                <div class="d-flex justify-content-center">
                    <?php echo e($receipts->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Receipt</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this receipt? This action cannot be undone.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <form id="deleteForm" method="POST" style="display: inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
    function deleteReceipt(id) {
        document.getElementById('deleteForm').action = '/admin/receipts/' + id;
        new bootstrap.Modal(document.getElementById('deleteModal')).show();
    }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\algodebug\resources\views/admin/receipts/index.blade.php ENDPATH**/ ?>