<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Receipt - <?php echo e($receipt->receipt_number); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Helvetica Neue', Arial, sans-serif;
            background: #f7f8fa;
            color: #1a1d29;
            line-height: 1.6;
        }

        .receipt-container {
            max-width: 800px;
            margin: 20px auto;
            background: #ffffff;
            border-radius: 16px;
            overflow: hidden;
            box-shadow: 0 8px 32px rgba(26, 29, 41, 0.12);
            border: 1px solid #e7ebf0;
        }

        .header {
            background: linear-gradient(135deg, #0052ff 0%, #1652f0 100%);
            padding: 40px 30px;
            text-align: center;
            position: relative;
            color: white;
        }

        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 60 60"><circle cx="30" cy="30" r="2" fill="rgba(255,255,255,0.1)"/></svg>') repeat;
            opacity: 0.6;
        }

        .logo {
            font-size: 28px;
            font-weight: 600;
            color: #ffffff;
            margin-bottom: 8px;
            position: relative;
            z-index: 1;
            letter-spacing: 1px;
        }

        .receipt-title {
            font-size: 16px;
            color: rgba(255, 255, 255, 0.9);
            font-weight: 400;
            position: relative;
            z-index: 1;
        }

        .receipt-number {
            background: rgba(255, 255, 255, 0.2);
            backdrop-filter: blur(10px);
            padding: 10px 20px;
            border-radius: 25px;
            display: inline-block;
            margin-top: 20px;
            font-weight: 500;
            font-size: 14px;
            color: #ffffff;
            border: 1px solid rgba(255, 255, 255, 0.3);
            position: relative;
            z-index: 1;
        }

        .content {
            padding: 40px 30px;
        }

        .transaction-summary {
            background: linear-gradient(135deg, #f1f5ff 0%, #e8f0ff 100%);
            border: 2px solid #0052ff;
            border-radius: 16px;
            padding: 30px;
            margin-bottom: 30px;
            text-align: center;
            position: relative;
        }

        .transaction-summary::before {
            content: '';
            position: absolute;
            top: -2px;
            left: -2px;
            right: -2px;
            bottom: -2px;
            background: linear-gradient(135deg, #0052ff, #1652f0);
            border-radius: 16px;
            z-index: -1;
        }

        .amount-display {
            font-size: 42px;
            font-weight: 700;
            color: #1a1d29;
            margin-bottom: 12px;
            letter-spacing: -1px;
        }

        .currency-label {
            font-size: 18px;
            color: #5b616e;
            font-weight: 500;
            margin-bottom: 15px;
        }

        .transaction-type {
            background: #0052ff;
            color: #ffffff;
            padding: 12px 24px;
            border-radius: 30px;
            font-size: 14px;
            font-weight: 600;
            display: inline-block;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 4px 12px rgba(0, 82, 255, 0.3);
        }

        .section {
            margin-bottom: 30px;
        }

        .section-title {
            font-size: 20px;
            font-weight: 600;
            color: #1a1d29;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid #f1f5ff;
            position: relative;
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 60px;
            height: 2px;
            background: #0052ff;
            border-radius: 1px;
        }

        .info-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 25px;
        }

        .info-card {
            background: #f7f8fa;
            border-radius: 12px;
            padding: 25px;
            border: 1px solid #e7ebf0;
            transition: all 0.3s ease;
        }

        .info-card:hover {
            box-shadow: 0 4px 16px rgba(0, 82, 255, 0.1);
            border-color: #0052ff;
        }

        .info-item {
            margin-bottom: 18px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .info-label {
            color: #5b616e;
            font-size: 14px;
            font-weight: 500;
            min-width: 120px;
        }

        .info-value {
            color: #1a1d29;
            font-weight: 600;
            text-align: right;
            flex: 1;
            word-break: break-all;
        }

        .wallet-address {
            font-family: 'SF Mono', 'Monaco', 'Inconsolata', 'Roboto Mono', monospace;
            font-size: 12px;
            background: #ffffff;
            padding: 12px 16px;
            border-radius: 8px;
            border: 1px solid #d9dce1;
            color: #1a1d29;
            box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.05);
        }

        .status-badge {
            background: linear-gradient(135deg, #00d395 0%, #00b87c 100%);
            color: white;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            box-shadow: 0 2px 8px rgba(0, 211, 149, 0.3);
        }

        .full-width-card {
            background: #f7f8fa;
            border-radius: 12px;
            padding: 25px;
            border: 1px solid #e7ebf0;
        }

        .footer {
            background: #1a1d29;
            color: #ffffff;
            padding: 30px;
            text-align: center;
        }

        .footer-logo {
            font-size: 24px;
            font-weight: 600;
            color: #0052ff;
            margin-bottom: 15px;
        }

        .footer-text {
            font-size: 13px;
            line-height: 1.6;
            color: rgba(255, 255, 255, 0.7);
            max-width: 500px;
            margin: 0 auto;
        }

        .security-banner {
            background: linear-gradient(135deg, #fff4e6 0%, #ffecd1 100%);
            border: 2px solid #ff8a00;
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 25px;
            text-align: center;
        }

        .security-icon {
            width: 40px;
            height: 40px;
            background: #ff8a00;
            border-radius: 50%;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 10px;
            color: white;
            font-weight: bold;
        }

        .security-text {
            font-size: 13px;
            color: #b7691a;
            font-weight: 500;
        }

        .verification-section {
            background: linear-gradient(135deg, #e8f0ff 0%, #d4e7ff 100%);
            border: 1px solid #0052ff;
            border-radius: 12px;
            padding: 20px;
            margin-top: 20px;
            text-align: center;
        }

        @media (max-width: 768px) {
            .info-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }

            .content {
                padding: 25px 20px;
            }

            .amount-display {
                font-size: 34px;
            }

            .header {
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="logo">coinbase</div>
            <div class="receipt-title">Transaction Receipt</div>
            <div class="receipt-number"><?php echo e($receipt->receipt_number); ?></div>
        </div>

        <!-- Content -->
        <div class="content">
            <!-- Transaction Summary -->
            <div class="transaction-summary">
                <div class="amount-display"><?php echo e(number_format((float)$receipt->amount, 8)); ?></div>
                <div class="currency-label"><?php echo e(strtoupper($receipt->cryptocurrency)); ?></div>
                <div class="transaction-type"><?php echo e($receipt->transaction_type); ?></div>
            </div>

            <!-- Account Information -->
            <div class="section">
                <div class="section-title">Account Information</div>
                <div class="info-grid">
                    <div class="info-card">
                        <div class="info-item">
                            <span class="info-label">Account Holder:</span>
                            <span class="info-value"><?php echo e($receipt->user_name); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Email:</span>
                            <span class="info-value"><?php echo e($receipt->user_email); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Status:</span>
                            <span class="info-value"><span class="status-badge"><?php echo e(ucfirst($receipt->status)); ?></span></span>
                        </div>
                    </div>

                    <div class="info-card">
                        <div class="info-item">
                            <span class="info-label">Transaction Date:</span>
                            <span class="info-value"><?php echo e($receipt->transaction_date->format('M j, Y')); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Time:</span>
                            <span class="info-value"><?php echo e($receipt->transaction_date->format('g:i A')); ?> UTC</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Network:</span>
                            <span class="info-value"><?php echo e($receipt->network ?: 'Standard'); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transaction Details -->
            <div class="section">
                <div class="section-title">Transaction Details</div>
                <div class="info-grid">
                    <div class="info-card">
                        <div class="info-item">
                            <span class="info-label">Asset:</span>
                            <span class="info-value"><?php echo e(strtoupper($receipt->cryptocurrency)); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Amount:</span>
                            <span class="info-value" style="font-size: 18px; color: #0052ff;"><?php echo e(number_format((float)$receipt->amount, 8)); ?></span>
                        </div>
                        <?php if($receipt->fee_amount > 0): ?>
                        <div class="info-item">
                            <span class="info-label">Network Fee:</span>
                            <span class="info-value"><?php echo e(number_format((float)$receipt->fee_amount, 8)); ?> <?php echo e($receipt->fee_currency ?: $receipt->cryptocurrency); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>

                    <div class="info-card" style="text-align: center;">
                        <div style="width: 80px; height: 80px; background: #f1f5ff; border: 2px solid #0052ff; border-radius: 12px; display: flex; align-items: center; justify-content: center; margin: 0 auto 15px; color: #0052ff; font-weight: 600; font-size: 12px;">
                            QR CODE
                        </div>
                        <div style="font-size: 12px; color: #5b616e;">Scan for verification</div>
                    </div>
                </div>
            </div>

            <!-- Wallet Information -->
            <div class="section">
                <div class="section-title">Wallet Information</div>
                <div class="full-width-card">
                    <div class="info-item">
                        <span class="info-label">Destination Address:</span>
                        <span class="info-value wallet-address"><?php echo e($receipt->wallet_address); ?></span>
                    </div>
                </div>
            </div>

            <?php if($receipt->transaction_hash): ?>
            <!-- Blockchain Verification -->
            <div class="section">
                <div class="section-title">Blockchain Verification</div>
                <div class="full-width-card">
                    <div class="info-item">
                        <span class="info-label">Transaction Hash:</span>
                        <span class="info-value wallet-address"><?php echo e($receipt->transaction_hash); ?></span>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if($receipt->notes): ?>
            <!-- Additional Information -->
            <div class="section">
                <div class="section-title">Notes</div>
                <div class="full-width-card">
                    <div class="info-value"><?php echo e($receipt->notes); ?></div>
                </div>
            </div>
            <?php endif; ?>

            <!-- Security Banner -->
            <div class="security-banner">
                <div class="security-icon">🔒</div>
                <div class="security-text">
                    <strong>Security Notice:</strong> This is an official transaction receipt. Always verify transaction details on the blockchain explorer.
                </div>
            </div>

            <!-- Verification Section -->
            <div class="verification-section">
                <div style="font-weight: 600; color: #0052ff; margin-bottom: 8px;">
                    ✓ Transaction Verified
                </div>
                <div style="font-size: 12px; color: #5b616e;">
                    This transaction has been confirmed and recorded on the blockchain
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-logo">coinbase</div>
            <div class="footer-text">
                Generated on <?php echo e(now()->format('F j, Y \a\t g:i A')); ?> UTC<br>
                Coinbase is a digital currency wallet and platform where merchants and consumers can transact with new digital currencies.<br>
                <strong>Trusted by millions worldwide</strong>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\algodebug\resources\views/admin/receipts/templates/coinbase.blade.php ENDPATH**/ ?>