<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Transaction Receipt - {{ $receipt->receipt_number }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Arial', sans-serif;
            background: #1a1a1a;
            color: #ffffff;
            line-height: 1.6;
        }

        .receipt-container {
            max-width: 800px;
            margin: 0 auto;
            background: linear-gradient(135deg, #2c2c2c 0%, #1a1a1a 100%);
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.5);
        }

        .header {
            background: linear-gradient(135deg, #f7931a 0%, #ff6b35 100%);
            padding: 30px;
            text-align: center;
            position: relative;
        }

        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100"><defs><pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse"><path d="M 10 0 L 0 0 0 10" fill="none" stroke="rgba(255,255,255,0.1)" stroke-width="0.5"/></pattern></defs><rect width="100" height="100" fill="url(%23grid)"/></svg>');
            opacity: 0.3;
        }

        .logo {
            font-size: 28px;
            font-weight: bold;
            color: #ffffff;
            margin-bottom: 10px;
            position: relative;
            z-index: 1;
        }

        .receipt-title {
            font-size: 18px;
            color: #ffffff;
            opacity: 0.9;
            position: relative;
            z-index: 1;
        }

        .receipt-number {
            background: rgba(255, 255, 255, 0.2);
            padding: 10px 20px;
            border-radius: 25px;
            display: inline-block;
            margin-top: 15px;
            font-weight: bold;
            position: relative;
            z-index: 1;
        }

        .content {
            padding: 40px;
        }

        .transaction-summary {
            background: rgba(247, 147, 26, 0.1);
            border: 2px solid #f7931a;
            border-radius: 10px;
            padding: 25px;
            margin-bottom: 30px;
            text-align: center;
        }

        .amount-display {
            font-size: 36px;
            font-weight: bold;
            color: #f7931a;
            margin-bottom: 10px;
        }

        .transaction-type {
            background: #f7931a;
            color: #ffffff;
            padding: 8px 16px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: bold;
            display: inline-block;
            text-transform: uppercase;
        }

        .details-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 30px;
            margin-bottom: 30px;
        }

        .detail-section {
            background: rgba(255, 255, 255, 0.05);
            border-radius: 8px;
            padding: 20px;
            border-left: 4px solid #f7931a;
        }

        .detail-title {
            font-size: 16px;
            font-weight: bold;
            color: #f7931a;
            margin-bottom: 15px;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .detail-item {
            margin-bottom: 12px;
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }

        .detail-label {
            color: #cccccc;
            font-size: 14px;
            min-width: 120px;
        }

        .detail-value {
            color: #ffffff;
            font-weight: 500;
            text-align: right;
            flex: 1;
            word-break: break-all;
        }

        .wallet-address {
            font-family: 'Courier New', monospace;
            font-size: 12px;
            background: rgba(0, 0, 0, 0.3);
            padding: 8px;
            border-radius: 4px;
            border: 1px solid #f7931a;
        }

        .status-badge {
            background: #4CAF50;
            color: white;
            padding: 6px 12px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: bold;
            text-transform: uppercase;
        }

        .footer {
            background: rgba(0, 0, 0, 0.5);
            padding: 25px 40px;
            text-align: center;
            border-top: 1px solid rgba(247, 147, 26, 0.3);
        }

        .footer-text {
            color: #cccccc;
            font-size: 12px;
            line-height: 1.5;
        }

        .security-note {
            background: rgba(255, 193, 7, 0.1);
            border: 1px solid #ffc107;
            border-radius: 6px;
            padding: 15px;
            margin-top: 20px;
            font-size: 12px;
            color: #ffc107;
        }

        @media (max-width: 768px) {
            .details-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }

            .content {
                padding: 20px;
            }

            .amount-display {
                font-size: 28px;
            }
        }
    </style>
</head>
<body>
    <div class="receipt-container">
        <!-- Header -->
        <div class="header">
            <div class="logo">BYBIT</div>
            <div class="receipt-title">Transaction Receipt</div>
            <div class="receipt-number"># {{ $receipt->receipt_number }}</div>
        </div>

        <!-- Content -->
        <div class="content">
            <!-- Transaction Summary -->
            <div class="transaction-summary">
                <div class="amount-display">{{ number_format((float)$receipt->amount, 8) }} {{ strtoupper($receipt->cryptocurrency) }}</div>
                <div class="transaction-type">{{ $receipt->transaction_type }}</div>
            </div>

            <!-- Details Grid -->
            <div class="details-grid">
                <!-- User Information -->
                <div class="detail-section">
                    <div class="detail-title">User Information</div>
                    <div class="detail-item">
                        <span class="detail-label">Name:</span>
                        <span class="detail-value">{{ $receipt->user_name }}</span>
                    </div>
                    <div class="detail-item">
                        <span class="detail-label">Email:</span>
                        <span class="detail-value">{{ $receipt->user_email }}</span>
                    </div>
                    <div class="detail-item">
                        <span class="detail-label">Wallet:</span>
                        <span class="detail-value wallet-address">{{ $receipt->wallet_address }}</span>
                    </div>
                </div>

                <!-- Transaction Details -->
                <div class="detail-section">
                    <div class="detail-title">Transaction Details</div>
                    <div class="detail-item">
                        <span class="detail-label">Date & Time:</span>
                        <span class="detail-value">{{ $receipt->transaction_date->format('M d, Y H:i:s') }} UTC</span>
                    </div>
                    <div class="detail-item">
                        <span class="detail-label">Network:</span>
                        <span class="detail-value">{{ $receipt->network ?: 'Standard' }}</span>
                    </div>
                    <div class="detail-item">
                        <span class="detail-label">Status:</span>
                        <span class="detail-value"><span class="status-badge">{{ ucfirst($receipt->status) }}</span></span>
                    </div>
                    @if($receipt->fee_amount > 0)
                    <div class="detail-item">
                        <span class="detail-label">Fee:</span>
                        <span class="detail-value">{{ number_format((float)$receipt->fee_amount, 8) }} {{ $receipt->fee_currency ?: $receipt->cryptocurrency }}</span>
                    </div>
                    @endif
                </div>
            </div>

            @if($receipt->transaction_hash)
            <!-- Transaction Hash -->
            <div class="detail-section">
                <div class="detail-title">Blockchain Information</div>
                <div class="detail-item">
                    <span class="detail-label">Transaction Hash:</span>
                    <span class="detail-value wallet-address">{{ $receipt->transaction_hash }}</span>
                </div>
            </div>
            @endif

            @if($receipt->notes)
            <!-- Notes -->
            <div class="detail-section">
                <div class="detail-title">Additional Notes</div>
                <div class="detail-item">
                    <span class="detail-value">{{ $receipt->notes }}</span>
                </div>
            </div>
            @endif

            <!-- Security Note -->
            <div class="security-note">
                <strong>Security Notice:</strong> This receipt is automatically generated and serves as proof of transaction.
                Please verify all transaction details on the blockchain explorer.
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <div class="footer-text">
                This receipt was generated on {{ now()->format('M d, Y H:i:s') }} UTC<br>
                For support and inquiries, please contact our customer service team<br>
                <strong>Always verify transactions independently on the blockchain</strong>
            </div>
        </div>
    </div>
</body>
</html>
